<?php   

class ControllerCommonHeader extends Controller {

	protected function index() {

		$this->data['title'] = $this->document->getTitle();

		

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {

			$this->data['base'] = $this->config->get('config_ssl');

		} else {

			$this->data['base'] = $this->config->get('config_url');

		}

		

		$this->data['description'] = $this->document->getDescription();

		$this->data['keywords'] = $this->document->getKeywords();

		$this->data['links'] = $this->document->getLinks();	 

		$this->data['styles'] = $this->document->getStyles();

		$this->data['scripts'] = $this->document->getScripts();

		$this->data['lang'] = $this->language->get('code');

		$this->data['direction'] = $this->language->get('direction');

		$this->data['google_analytics'] = html_entity_decode($this->config->get('config_google_analytics'), ENT_QUOTES, 'UTF-8');



		// Whos Online

		if ($this->config->get('config_customer_online')) {

			$this->load->model('tool/online');

	

			if (isset($this->request->server['REMOTE_ADDR'])) {

				$ip = $this->request->server['REMOTE_ADDR'];	

			} else {

				$ip = ''; 

			}

			

			if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {

				$url = 'http://' . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];	

			} else {

				$url = '';

			}

			

			if (isset($this->request->server['HTTP_REFERER'])) {

				$referer = $this->request->server['HTTP_REFERER'];	

			} else {

				$referer = '';

			}

						

			$this->model_tool_online->whosonline($ip, $this->customer->getId(), $url, $referer);

		}

				

		$this->language->load('common/header');

		

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {

			$server = HTTPS_IMAGE;

		} else {

			$server = HTTP_IMAGE;

		}	

				

		if ($this->config->get('config_icon') && file_exists(DIR_IMAGE . $this->config->get('config_icon'))) {

			$this->data['icon'] = $server . $this->config->get('config_icon');

		} else {

			$this->data['icon'] = '';

		}

		

		$this->data['name'] = $this->config->get('config_name');

				

		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {

			$this->data['logo'] = $server . $this->config->get('config_logo');

		} else {

			$this->data['logo'] = '';

		}

		

		$this->data['text_home'] = $this->language->get('text_home');

		$this->data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));

		$this->data['text_shopping_cart'] = $this->language->get('text_shopping_cart');

    	$this->data['text_search'] = $this->language->get('text_search');

		$this->data['text_welcome'] = sprintf($this->language->get('text_welcome'), $this->url->link('account/login', '', 'SSL'), $this->url->link('account/register', '', 'SSL'));
		
		$this->data['text_welcome_img'] = sprintf($this->language->get('text_welcome_img'), $this->url->link('account/login', '', 'SSL'), $this->url->link('account/register', '', 'SSL'));

		$this->data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', 'SSL'), $this->customer->getFirstName(), $this->url->link('account/logout', '', 'SSL'));

		$this->data['text_account'] = $this->language->get('text_account');

    	$this->data['text_checkout'] = $this->language->get('text_checkout');

				

		$this->data['home'] = $this->url->link('common/home');

		$this->data['wishlist'] = $this->url->link('account/wishlist', '', 'SSL');

		$this->data['logged'] = $this->customer->isLogged();

		$this->data['account'] = $this->url->link('account/account', '', 'SSL');

		$this->data['shopping_cart'] = $this->url->link('checkout/cart');

		$this->data['checkout'] = $this->url->link('checkout/checkout', '', 'SSL');

		

		if (isset($this->request->get['filter_name'])) {

			$this->data['filter_name'] = $this->request->get['filter_name'];

		} else {

			$this->data['filter_name'] = '';

		}

		

		// Menu

		$this->load->model('catalog/category');

		

		$this->load->model('catalog/product');

		

		$this->data['categories'] = array();

					

		$categories = $this->model_catalog_category->getCategories(0);

		

		foreach ($categories as $category) {

			if ($category['top']) {

				$children_data = array();

				

				$children = $this->model_catalog_category->getCategories($category['category_id']);

				

				foreach ($children as $child) {

					$data = array(

						'filter_category_id'  => $child['category_id'],

						'filter_sub_category' => true

					);

					

					$product_total = $this->model_catalog_product->getTotalProducts($data);

									

					$children_data[] = array(

						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $product_total . ')' : ''),

						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])	

					);						

				}

				

				// Level 1

				$this->data['categories'][] = array(

					'name'     => $category['name'],

					'children' => $children_data,

					'column'   => $category['column'] ? $category['column'] : 1,

					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])

				);

			}

		}

		

		$this->children = array(

			'module/language',

			'module/currency',

			'module/cart'

		);

				

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/header.tpl')) {

			$this->template = $this->config->get('config_template') . '/template/common/header.tpl';

		} else {

			$this->template = 'default/template/common/header.tpl';

		}

		

    	$this->render();

	} 	

}

?>